/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.ovr;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct ovrLayerHeader")
public class OVRLayerHeader
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int TYPE;
    public static final int FLAGS;

    public OVRLayerHeader(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), OVRLayerHeader.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="ovrLayerType")
    public int Type() {
        return OVRLayerHeader.nType(this.address());
    }

    @NativeType(value="unsigned int")
    public int Flags() {
        return OVRLayerHeader.nFlags(this.address());
    }

    public OVRLayerHeader Type(@NativeType(value="ovrLayerType") int value) {
        OVRLayerHeader.nType(this.address(), value);
        return this;
    }

    public OVRLayerHeader Flags(@NativeType(value="unsigned int") int value) {
        OVRLayerHeader.nFlags(this.address(), value);
        return this;
    }

    public OVRLayerHeader set(int Type, int Flags) {
        this.Type(Type);
        this.Flags(Flags);
        return this;
    }

    public OVRLayerHeader set(OVRLayerHeader src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static OVRLayerHeader malloc() {
        return (OVRLayerHeader)OVRLayerHeader.wrap(OVRLayerHeader.class, (long)MemoryUtil.nmemAllocChecked((long)SIZEOF));
    }

    public static OVRLayerHeader calloc() {
        return (OVRLayerHeader)OVRLayerHeader.wrap(OVRLayerHeader.class, (long)MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF));
    }

    public static OVRLayerHeader create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return (OVRLayerHeader)OVRLayerHeader.wrap(OVRLayerHeader.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (ByteBuffer)container);
    }

    public static OVRLayerHeader create(long address) {
        return (OVRLayerHeader)OVRLayerHeader.wrap(OVRLayerHeader.class, (long)address);
    }

    @Nullable
    public static OVRLayerHeader createSafe(long address) {
        return address == 0L ? null : (OVRLayerHeader)OVRLayerHeader.wrap(OVRLayerHeader.class, (long)address);
    }

    public static Buffer malloc(int capacity) {
        return (Buffer)OVRLayerHeader.wrap(Buffer.class, (long)MemoryUtil.nmemAllocChecked((long)OVRLayerHeader.__checkMalloc((int)capacity, (int)SIZEOF)), (int)capacity);
    }

    public static Buffer calloc(int capacity) {
        return (Buffer)OVRLayerHeader.wrap(Buffer.class, (long)MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), (int)capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = OVRLayerHeader.__create((int)capacity, (int)SIZEOF);
        return (Buffer)OVRLayerHeader.wrap(Buffer.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (int)capacity, (ByteBuffer)container);
    }

    public static Buffer create(long address, int capacity) {
        return (Buffer)OVRLayerHeader.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : (Buffer)OVRLayerHeader.wrap(Buffer.class, (long)address, (int)capacity);
    }

    public static OVRLayerHeader mallocStack() {
        return OVRLayerHeader.mallocStack(MemoryStack.stackGet());
    }

    public static OVRLayerHeader callocStack() {
        return OVRLayerHeader.callocStack(MemoryStack.stackGet());
    }

    public static OVRLayerHeader mallocStack(MemoryStack stack) {
        return (OVRLayerHeader)OVRLayerHeader.wrap(OVRLayerHeader.class, (long)stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static OVRLayerHeader callocStack(MemoryStack stack) {
        return (OVRLayerHeader)OVRLayerHeader.wrap(OVRLayerHeader.class, (long)stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return OVRLayerHeader.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return OVRLayerHeader.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return (Buffer)OVRLayerHeader.wrap(Buffer.class, (long)stack.nmalloc(ALIGNOF, capacity * SIZEOF), (int)capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return (Buffer)OVRLayerHeader.wrap(Buffer.class, (long)stack.ncalloc(ALIGNOF, capacity, SIZEOF), (int)capacity);
    }

    public static int nType(long struct) {
        return UNSAFE.getInt(null, struct + (long)TYPE);
    }

    public static int nFlags(long struct) {
        return UNSAFE.getInt(null, struct + (long)FLAGS);
    }

    public static void nType(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)TYPE, value);
    }

    public static void nFlags(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)FLAGS, value);
    }

    static {
        Struct.Layout layout = OVRLayerHeader.__struct((int)DEFAULT_PACK_ALIGNMENT, (int)POINTER_SIZE, (Struct.Member[])new Struct.Member[]{OVRLayerHeader.__member((int)4), OVRLayerHeader.__member((int)4), OVRLayerHeader.__padding((int)128, (boolean)true)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        TYPE = layout.offsetof(0);
        FLAGS = layout.offsetof(1);
    }

    public static class Buffer
    extends StructBuffer<OVRLayerHeader, Buffer>
    implements NativeResource {
        private static final OVRLayerHeader ELEMENT_FACTORY = OVRLayerHeader.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected OVRLayerHeader getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="ovrLayerType")
        public int Type() {
            return OVRLayerHeader.nType(this.address());
        }

        @NativeType(value="unsigned int")
        public int Flags() {
            return OVRLayerHeader.nFlags(this.address());
        }

        public Buffer Type(@NativeType(value="ovrLayerType") int value) {
            OVRLayerHeader.nType(this.address(), value);
            return this;
        }

        public Buffer Flags(@NativeType(value="unsigned int") int value) {
            OVRLayerHeader.nFlags(this.address(), value);
            return this;
        }
    }
}

